<section class="slider">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12 col-lg-12 pe-0 ps-0">
         <div>
             <button id="prevButton" class="wave"><i class="fa-solid fa-chevron-left"></i></button>
             <button id="nextButton" class="wave"><i class="fa-solid fa-chevron-right"></i></button>
           </div>
           <div class="text">
             <h1 class="h1">Special Cheese</h1>
             <div class="cane-image ">
               <img src="../assets/images/slider-resimleri/urun-01.png" alt="Snapwitch">
               <img src="" alt="" class="cane-labels">
             </div>
           </div>
           <div class="section-container-main">
           <div class="section-container">
             <section class="section" id="section1">
               <div class="fruit-images">
                 <div class="image-one fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-01.png" alt="Snapwitch"></div>
                 <div class="image-two fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-02.png" alt="Snapwitch"></div>
                 <div class="image-three fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-03.png" alt="Snapwitch"></div>
                 <div class="image-four fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-04.png" alt="Snapwitch"></div>
               </div>
             </section>
             <section class="section" id="section2">
               <div class="fruit-images">
                  <div class="image-one fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-02-01.png" alt="Snapwitch"></div>
                 <div class="image-two fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-02-02.png" alt="Snapwitch"></div>
                 <div class="image-three fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-02-03.png" alt="Snapwitch"></div>
                 <div class="image-four fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-02-04.png" alt="Snapwitch"></div>
               </div>
             </section>
             <section class="section" id="section3">
               <div class="fruit-images">
                  <div class="image-one fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-03-01.png" alt="Snapwitch"></div>
                 <div class="image-two fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-03.02.png" alt="Snapwitch"></div>
                 <div class="image-three fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-03-03.png" alt="Snapwitch"></div>
                 <div class="image-four fruit-image"><img src="../assets/images/slider-resimleri/urun-alt-03-04.png" alt="Snapwitch"></div>
               </div>
             </section>
           </div>
         </div>
      </div>
    </div>
  </div>
</section>
<script src="https://cdn.jsdelivr.net/npm/gsap@3.12.2/dist/gsap.min.js"></script>
<script>
let h1Texts = ["Special Cheese", "Roll Ekmeği", "Çavdar Ekmeği"]; 
let logoColors = [
  "var(--pear-logo)",
  "var(--apple-logo)",
  "var(--exotic-logo)"
]; 
let keyframes = ["wave-pear-effect", "wave-apple-effect", "wave-exotic-effect"];
const bigFruitSrc = [
  "../assets/images/slider-resimleri/urun-01.png",
  "../assets/images/slider-resimleri/urun-02.png",
  "../assets/images/slider-resimleri/urun-03.png",
];
gsap.from(".fruit-image", { y: "-100vh", delay: 0.5 });
gsap.to(".fruit-image img", {
  x: "random(-20, 20)",
  y: "random(-20, 20)",
  zIndex: 22,
  duration: 2,
  ease: "none",
  yoyo: true,
  repeat: -1
});
const prevButton = document.getElementById("prevButton");
const nextButton = document.getElementById("nextButton");
const caneLabels = document.querySelector(".cane-labels");
const sectionContainer = document.querySelector(".section-container");
const h1Element = document.querySelector(".h1");
const mainImage = document.querySelector(".cane-image img:first-child");
let currentIndex = 0;
let currentPosition = 0;
prevButton.style.display = "none";
if (mainImage) {
  mainImage.src = bigFruitSrc[0];
}
nextButton.addEventListener("click", () => {
  if (currentPosition > -200) {
    currentPosition -= 100;
    caneLabels.style.left = `${currentPosition}%`;
    sectionContainer.style.left = `${currentPosition}%`;
  }
  currentIndex++;
  if (currentIndex < h1Texts.length) {
    h1Element.innerHTML = h1Texts[currentIndex];
  }
  if (mainImage && currentIndex < bigFruitSrc.length) {
    mainImage.src = bigFruitSrc[currentIndex];
  }
  gsap.to(".logo", {
    opacity: 1,
    duration: 1,
    color: logoColors[currentIndex]
  });
  gsap.from(".h1", { y: "20%", opacity: 0, duration: 0.5 });
  gsap.from(".fruit-image", { y: "-100vh", delay: 0.4, duration: 0.4 });
  if (currentIndex === h1Texts.length - 1) {
    nextButton.style.display = "none";
  }
  if (currentIndex > 0) {
    prevButton.style.display = "block";
  }
  nextButton.style.color = logoColors[currentIndex + 1] || "inherit";
  prevButton.style.color = logoColors[currentIndex - 1] || "inherit";
  nextButton.style.animationName = keyframes[currentIndex + 1] || "none";
  prevButton.style.animationName = keyframes[currentIndex - 1] || "none";
});
prevButton.addEventListener("click", () => {
  if (currentPosition < 0) {
    currentPosition += 100;
    caneLabels.style.left = `${currentPosition}%`;
    sectionContainer.style.left = `${currentPosition}%`;
    sectionContainer.style.transition = `all 0.5s ease-in-out`;
  }
  currentIndex--;
  if (currentIndex >= 0) {
    h1Element.innerHTML = h1Texts[currentIndex];
  }
  if (mainImage && currentIndex >= 0) {
    mainImage.src = bigFruitSrc[currentIndex];
  }
  gsap.to(".logo", { color: logoColors[currentIndex], duration: 1 });
  gsap.from(".h1", { y: "20%", opacity: 0, duration: 0.5 });
  gsap.from(".fruit-image", { y: "100vh", delay: 0.5 });
  nextButton.style.display = "block";
  if (currentIndex === 0) {
    prevButton.style.display = "none";
  }
  nextButton.style.color = logoColors[currentIndex + 1] || "inherit";
  prevButton.style.color = logoColors[currentIndex - 1] || "inherit";
  nextButton.style.animationName = keyframes[currentIndex + 1] || "none";
  prevButton.style.animationName = keyframes[currentIndex - 1] || "none";
});
 </script>

